package com.ejie.ab04b.control;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.model.EmpresaAuditora;
import com.ejie.ab04b.service.EmpresaAuditoraService;
import com.ejie.ab04b.util.UtilidadesWar;
import com.ejie.ab04b.util.Utilities;
import com.ejie.x38.control.bind.annotation.RequestJsonBody;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0479s00Controller generated by UDA, 26-may-2017 13:35:11.
 * 
 * @author UDA
 */

@Controller()
@RequestMapping(value = "/empresaauditora")
public class EmpresaAuditoraController {

	private static final Logger logger = LoggerFactory
			.getLogger(EmpresaAuditoraController.class);

	@Autowired()
	private EmpresaAuditoraService empresaAuditoraService;
	@Autowired()
	private ReloadableResourceBundleMessageSource messageSource;

	/**
	 * Usamos este mÃ©todo para indicarle a Spring el formato que debe usar para
	 * serializar las fechas cuando cargamos la entidad en el Model. En el resto
	 * de peticiones que devuelven un objeto con la anotaciÃ³n '@ResponseBody'
	 * se usan los serializadores de UDA
	 * 
	 *  binder
	 *            WebDataBinder
	 *
	 * @param binder the binder
	 */
	@InitBinder()
	public void initBinder(WebDataBinder binder) {

		Locale locale = LocaleContextHolder.getLocale();
		DateFormat dateFormat = null;
		if (locale.equals(Constantes.LOCALE_ES)) {
			dateFormat = new SimpleDateFormat(Constantes.ES_DATE_MASK);
		} else {
			dateFormat = new SimpleDateFormat(Constantes.EU_DATE_MASK);
		}
		binder.registerCustomEditor(Date.class,
				new CustomDateEditor(dateFormat, true));
	}

	/*
	 * OPERACIONES CRUD (Create, Read, Update, Delete)
	 */

	/**
	 * Operacion CRUD Read. Devuelve el bean correspondiente al identificador
	 * indicado.
	 * 
	 *  codempaud079
	 *            String
	 *
	 * @param codempaud079 the codempaud 079
	 *  Ab0479s00 Objeto correspondiente al identificador indicado.
	 * @return the empresa auditora
	 */
	@RequestMapping(value = "/{codempaud079}", method = RequestMethod.GET)
	public @ResponseBody EmpresaAuditora get(
			@PathVariable String codempaud079) {
		EmpresaAuditora empresaAuditora = new EmpresaAuditora();
		empresaAuditora.setCodempaud079(codempaud079);
		empresaAuditora = this.empresaAuditoraService.find(empresaAuditora);
		EmpresaAuditoraController.logger
				.info("[GET - findBy_PK] : Obtener EmpresaAuditora por PK");
		return empresaAuditora;
	}

	/**
	 * Devuelve una lista de beans correspondientes a los valores de filtrados
	 * indicados en el objeto pasado como parametro.
	 * 
	 *  filterEmpresaAuditora
	 *            EmpresaAuditora Objeto que contiene los parametros de filtrado
	 *            utilizados en la busqueda.
	 *
	 * @param filterEmpresaAuditora the filter empresa auditora
	 *  List<Ab0479s00> Lista de objetos correspondientes a la busqueda
	 *         realizada.
	 * @return the all
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<EmpresaAuditora> getAll(
			@ModelAttribute EmpresaAuditora filterEmpresaAuditora) {
		EmpresaAuditoraController.logger
				.info("[GET - find_ALL] : Obtener EmpresaAuditora por filtro");
		return this.empresaAuditoraService.findAll(filterEmpresaAuditora, null);
	}

	/**
	 * Operacion CRUD Edit. Modificacion del bean indicado.
	 * 
	 *  empresaAuditora
	 *            EmpresaAuditora Bean que contiene la informacion a modificar.
	 *
	 * @param empresaAuditora the empresa auditora
	 *  Ab0479s00 Bean resultante de la modificacion.
	 * @return the empresa auditora
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody EmpresaAuditora edit(
			@RequestBody EmpresaAuditora empresaAuditora) {
		EmpresaAuditora EmpresaAuditoraAux = this.empresaAuditoraService
				.update(empresaAuditora);
		EmpresaAuditoraController.logger
				.info("[PUT] : EmpresaAuditora actualizado correctamente");
		return EmpresaAuditoraAux;
	}

	/**
	 * Operacion CRUD Create. Creacion de un nuevo registro a partir del bean
	 * indicado.
	 * 
	 *  empresaAuditora
	 *            Ab0479s00 Bean que contiene la informacion con la que se va a
	 *            crear el nuevo registro.
	 *
	 * @param empresaAuditora the empresa auditora
	 *  Ab0479s00 Bean resultante del proceso de creacion.
	 * @return the empresa auditora
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody EmpresaAuditora add(
			@RequestBody EmpresaAuditora empresaAuditora) {
		EmpresaAuditora empresaAuditoraAux = this.empresaAuditoraService
				.add(empresaAuditora);
		EmpresaAuditoraController.logger
				.info("[POST] : EmpresaAuditora insertado correctamente");
		return empresaAuditoraAux;
	}

	/**
	 * Operacion CRUD Delete. Borrado del registro correspondiente al
	 * identificador especificado.
	 * 
	 *  codempaud079
	 *            String Identificador del objeto que se desea eliminar.
	 *
	 * @param codempaud079 the codempaud 079
	 *  Ab0479s00 Bean eliminado.
	 * @return the empresa auditora
	 */
	@RequestMapping(value = "/{codempaud079}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody EmpresaAuditora remove(
			@PathVariable String codempaud079) {
		EmpresaAuditora empresaAuditora = new EmpresaAuditora();
		empresaAuditora.setCodempaud079(codempaud079);
		this.empresaAuditoraService.remove(empresaAuditora);
		EmpresaAuditoraController.logger
				.info("[DELETE] : EmpresaAuditora borrado correctamente");
		return empresaAuditora;
	}

	/*
	 * METODOS COMPONENTE RUP_TABLE
	 */

	/**
	 * Metodo de presentacion del RUP_TABLE.
	 * 
	 *  model
	 *            Model
	 *
	 * @param model the model
	 *  String
	 * @return the form edit
	 */
	@RequestMapping(value = "/maint", method = RequestMethod.GET)
	public String getFormEdit(Model model) {
		EmpresaAuditoraController.logger.info("[GET - View] : EmpresaAuditora");
		return "empresaauditora";
	}

	/**
	 * Operacion de filtrado del componente RUP_TABLE.
	 * 
	 *  filterEmpresaAuditora
	 *            EmpresaAuditora Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en el filtrado.
	 *
	 * @param filterEmpresaAuditora the filter empresa auditora
	 * @param jqGridRequestDto the jq grid request dto
	 *  JQGridResponseDto<Ab0479s00> Dto que contiene el resultado del
	 *         filtrado realizado por el componente RUP_TABLE.
	 * @return the JQ grid response dto
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.POST)
	public @ResponseBody JQGridResponseDto<EmpresaAuditora> filter(
			@RequestJsonBody(param = "filter") EmpresaAuditora filterEmpresaAuditora,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		EmpresaAuditoraController.logger
				.info("[POST - filter] : Obtener EmpresaAuditora");
		return this.empresaAuditoraService.filter(filterEmpresaAuditora,
				jqGridRequestDto, false);
	}

	/**
	 * Operacion de busqueda del componente RUP_TABLE.
	 * 
	 *  filterEmpresaAuditora
	 *            EmpresaAuditora Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  searchEmpresaAuditora
	 *            EmpresaAuditora Bean que contiene los parametros de busqueda a
	 *            emplear.
	 *  jqGridRequestDto
	 *            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la búsqueda.
	 *
	 * @param filterEmpresaAuditora the filter empresa auditora
	 * @param searchEmpresaAuditora the search empresa auditora
	 * @param jqGridRequestDto the jq grid request dto
	 *  TableRowDto<Ab0479s00> Dto que contiene el resultado de la
	 *         busqueda realizada por el componente RUP_TABLE.
	 * @return the list
	 */
	@RequestMapping(value = "/search", method = RequestMethod.POST)
	public @ResponseBody List<TableRowDto<EmpresaAuditora>> search(
			@RequestJsonBody(param = "filter") EmpresaAuditora filterEmpresaAuditora,
			@RequestJsonBody(param = "search") EmpresaAuditora searchEmpresaAuditora,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		EmpresaAuditoraController.logger
				.info("[POST - search] : Buscar EmpresaAuditora");
		return this.empresaAuditoraService.search(filterEmpresaAuditora,
				searchEmpresaAuditora, jqGridRequestDto, false);
	}

	/**
	 * Borrado multiple de registros.
	 * 
	 *  filterEmpresaAuditora            EmpresaAuditora Bean que contiene los parametros de filtrado a
	 *            emplear.
	 *  jqGridRequestDto            Dto que contiene los parametros de configuracion propios del
	 *            RUP_TABLE a aplicar en la busqueda.
	 *
	 * @param filterEmpresaAuditora the filter empresa auditora
	 * @param jqGridRequestDto the jq grid request dto
	 *  List<String> Lista de los identificadores de los registros
	 *         eliminados.
	 * @return the list
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<String> removeMultiple(
			@RequestJsonBody(param = "filter") EmpresaAuditora filterEmpresaAuditora,
			@RequestJsonBody JQGridRequestDto jqGridRequestDto) {
		EmpresaAuditoraController.logger.info(
				"[POST - search] : [POST - removeMultiple] : Eliminar multiples EmpresaAuditora");
		this.empresaAuditoraService.removeMultiple(filterEmpresaAuditora,
				jqGridRequestDto, false);
		EmpresaAuditoraController.logger
				.info("All entities correctly deleted!");

		return jqGridRequestDto.getMultiselection().getSelectedIds();
	}

	/**
	 * Realiza la exportaciÃ³n a Excel.
	 * 
	 *  filterEmpresaAuditora            EmpresaAuditora Bean que contiene los parÃ¡metros de filtrado
	 *            a emplear.
	 *  jqGridRequestDto            JQGridRequestDto que contiene los parÃ¡mtros de configuraciÃ³n
	 *            propios del RUP_TABLE a aplicar en el filtrado.
	 *  modelMap            ModelMap
	 *  columns            String
	 *  request            HttpServletRequest
	 *
	 * @param filterEmpresaAuditora the filter empresa auditora
	 * @param jqGridRequestDto the jq grid request dto
	 * @param modelMap the model map
	 * @param columns the columns
	 * @param request the request
	 *  ModelAndView
	 * @return the report
	 */
	@RequestMapping(value = { "xlsReport",
			"xlsxReport" }, method = RequestMethod.POST)
	protected ModelAndView getReport(
			@ModelAttribute() EmpresaAuditora filterEmpresaAuditora,
			@ModelAttribute() JQGridRequestDto jqGridRequestDto,
			ModelMap modelMap,
			@RequestParam(value = "columns", required = false) String columns,
			HttpServletRequest request) {

		// Limpiamos los datos de paginacion para mostrar todos los registros
		jqGridRequestDto.setPage(null);
		jqGridRequestDto.setRows(null);

		// Acceso a BD para recuperar datos
		List<EmpresaAuditora> listEmpresaAuditora = this.empresaAuditoraService
				.findAllLike(filterEmpresaAuditora, jqGridRequestDto, false);

		// GENERAMOS EL FICHERO
		UtilidadesWar.generateReport(modelMap,
				Utilities.getLiteralMessage(this.messageSource,
						"excel.titulo.empresaAuditora"),
				columns, listEmpresaAuditora);

		// GeneraciÃ³n del XLS o XLSX
		if (request.getServletPath().indexOf("xlsReport") != -1) {
			return new ModelAndView("xlsReport", modelMap);
		} else {
			return new ModelAndView("xlsxReport", modelMap);
		}
	}

}
